/* CReplace.c
 *
 * Class that implements an undoable replace.
 *
 */
/*
 * Copyright (C) 1985-1992  New York University
 * Copyright (C) 1994 George Washington University
 * 
 * This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
 * system.  See the Ada/Ed README file for warranty (none) and distribution
 * info and also the GNU General Public License for more details.
 */


#include "CReplace.h"
#include <TBUtilities.h>
#include "CTextPane.h"
#include "CTextDocument.h"

void	CReplace::IReplace(CTextDocument *doc, Str255 rep)
{
CTextPane *editText;
Handle text;
long hSize;

	itsDoc = doc;


	editText = itsDoc->fTextEdit;
	editText->GetSelection(&selStart, &selEnd);
	text = editText->CopyTextRange(selStart, selEnd);
	hSize = GetHandleSize(text);
	if (hSize > 255) {
		hSize = 255;
		selEnd = selStart + hSize;
	}

	HLock(text);
	BlockMove(*text, &selStr[1], hSize);
	selStr[0] = hSize;
	HUnlock(text);
	DisposeHandle(text);

	CopyPString(rep, repStr);
	repStart = selStart;
	repEnd = repStart + repStr[0];
}

void	CReplace::Undo(void)
{
CTextPane *editText;
int x;
Str255 temp;

	editText = itsDoc->fTextEdit;

	editText->SetSelection(selStart, selEnd, false);
	editText->TypeChar(0x08, 0);		/* backspace */
	editText->InsertTextPtr((Ptr)&selStr[1], selStr[0], true);

	/* Switch values around */
	x = selStart;
	selStart = repStart;
	repStart = x;
	
	x = selEnd;
	selEnd = repEnd;
	repEnd = x;

	CopyPString(selStr, temp);
	CopyPString(repStr, selStr);
	CopyPString(temp, repStr);
}
